local assets =
{
	Asset("ANIM", "anim/maizi.zip"),
    Asset("ATLAS", "images/inventoryimages/wheat.xml"),
	Asset("ANIM", "anim/dough.zip"),
    Asset("ATLAS", "images/inventoryimages/dough.xml"),
	Asset("ANIM", "anim/flour.zip"),
	Asset("ATLAS","images/inventoryimages/flour.xml")
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("maizi")
    inst.AnimState:SetBuild("maizi")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "wheat"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wheat.xml"
    inst:AddComponent("selfstacker")
	--食物组件
	inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_FAST*2)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"
	 inst:AddComponent("edible")
    inst.components.edible.healthvalue = 1
    inst.components.edible.hungervalue = 1
	inst.components.edible.sanityvalue = 1
    inst.components.edible.foodtype = FOODTYPE.VEGGIE

    MakeHauntableLaunchAndSmash(inst)

    return inst
end
local function doughfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("dough")
    inst.AnimState:SetBuild("dough")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "dough"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/dough.xml"
    inst:AddComponent("selfstacker")
	--食物组件
	inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_FAST)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"
	 inst:AddComponent("edible")
    inst.components.edible.healthvalue = 1
    inst.components.edible.hungervalue = 5
	inst.components.edible.sanityvalue = 1
    inst.components.edible.foodtype = FOODTYPE.VEGGIE

    MakeHauntableLaunchAndSmash(inst)

    return inst
end
local function flourfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("flour")
    inst.AnimState:SetBuild("flour")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
	inst:AddComponent("tradable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "flour"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/flour.xml"
    inst:AddComponent("selfstacker")

    MakeHauntableLaunchAndSmash(inst)

    return inst
end
return Prefab("dough", doughfn, assets),
 Prefab("maizi", fn, assets),
 Prefab("flour", flourfn, assets)